/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.compras;

import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.catalogos.ConceptosRetencionBanano;
import ec.gob.sri.dimm.ats.modelo.catalogos.Dividendos;
import ec.gob.sri.dimm.ats.modelo.obj.DetalleAir;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.joda.time.LocalDate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DetalleAirCompras
extends DetalleAir
implements Exportable {
    private static final long serialVersionUID = -7237652980959388030L;
    public static final String C_FECHA_PAGO_DIV = "fechaPagoDividendo";
    public static final String C_IR_SOCIENDAD = "impuestoRentaSociedad";
    public static final String C_ANIO_UTILIDADES_DIV = "anioUtilidadesDiv";
    public static final String NUMERO_CAJAS_DE_BANANO = "numeroCajasDeBanano";
    public static final String PRECIO_CAJA_DE_BANANO = "precioCajaDeBanano";
    @NotNull(message="Fecha de pago")
    private Date fechaPagoDividendo = new Date();
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Impuesto Renta Sociedad  debe ser 12 enteros y 2 decimales. ")
    private String impuestoRentaSociedad;
    @NotNull(message="Debe ingresar el valor de A\u00f1o")
    @Pattern(regexp="\\d{4}", message="Debe ingresar un a\u00f1o v\u00e1lido")
    private String anioUtilidadesDiv;
    private String numeroCajasDeBanano;
    private String precioCajaDeBanano;
    private BigDecimal porcentajeRetencionCalculoBanano;
    private BigDecimal valorRetenidoPorBanano;
    private transient Map<String, BigDecimal> retencionDividendos = null;

    public void inicializar() {
        this.impuestoRentaSociedad = "0.00";
        this.fechaPagoDividendo = ((Iva)this.getRaizModelo()).getFechaPeriodoDeclarado().getTime();
        this.anioUtilidadesDiv = String.valueOf(((Iva)this.getRaizModelo()).getFechaPeriodoDeclarado().get(1));
        this.numeroCajasDeBanano = "000";
        this.precioCajaDeBanano = "0.00";
        this.porcentajeRetencionCalculoBanano = BigDecimal.ZERO;
        this.valorRetenidoPorBanano = BigDecimal.ZERO;
    }

    @Override
    protected ResultadoValidacion validacionExtra(ResultadoValidacion resultado) {
        if (this.validarPorcentajeNoMayorA35DesdeAgosto2015(resultado).esEstadoFallido()) {
            return resultado;
        }
        if (this.esRetencionConDividendosPorPeriodo()) {
            if (this.validarFechaPagoDividendo(resultado).esEstadoFallido()) {
                return resultado;
            }
            if (!this.validarImpuestoRentaSociedad(resultado).esEstadoExitoso()) {
                return resultado;
            }
            if (this.validarAnioUtilidadesDiv(resultado).esEstadoFallido()) {
                return resultado;
            }
        }
        if (this.esPeriodoDesdeMarzoyEsExportacionDeBanano()) {
            if (this.validarNumeroCajasBanano(resultado).esEstadoFallido()) {
                return resultado;
            }
            if (this.validarPrecioCajaBanano(resultado).esEstadoFallido()) {
                return resultado;
            }
        }
        return resultado;
    }

    private boolean esRetencionConDividendosPorPeriodo() {
        boolean esRetencionConDividendoDesdeMarzo2015;
        boolean esRetencionConDividendoEnPeriodoEne2013AFeb2015 = this.getPeriodo().isPeridoDeAnexoDesdeEnero2013aFebrero2015() && Dividendos.RETENCIONES_CON_DIVIDENDOS_NATURALES_2013_FEB_2015.containsKey(this.getConceptoRetencion());
        boolean bl = esRetencionConDividendoDesdeMarzo2015 = this.getPeriodo().isPeriodoDeAnexoDesdeMarzo2015() && Dividendos.RETENCIONES_CON_DIVIDENDOS_DESDE_MARZO_2015.containsKey(this.getConceptoRetencion());
        return esRetencionConDividendoEnPeriodoEne2013AFeb2015 || esRetencionConDividendoDesdeMarzo2015;
    }

    private ResultadoValidacion validarNumeroCajasBanano(ResultadoValidacion resultado) {
        if (this.numeroCajasDeBanano == null || this.numeroCajasDeBanano.isEmpty()) {
            return resultado.fallarValidacion("Debe ingresar un valor para el n\u00famero de cajas de banano");
        }
        try {
            Double.parseDouble(this.numeroCajasDeBanano);
        }
        catch (NumberFormatException numberFormatException) {
            return resultado.fallarValidacion("Debe ingresar solo valores enteros en el n\u00famero de cajas de banano");
        }
        return resultado;
    }

    private ResultadoValidacion validarPrecioCajaBanano(ResultadoValidacion resultado) {
        if (this.precioCajaDeBanano == null || this.precioCajaDeBanano.isEmpty()) {
            return resultado.fallarValidacion("Debe ingresar el precio por caja de banano");
        }
        if (!this.precioCajaDeBanano.matches("^[0-9]{1,2}+(\\.[0-9]{2})?$")) {
            return resultado.fallarValidacion("Debe ingresar un valor v\u00e1lido en el precio por caja de banano");
        }
        if (this.precioCajaDeBanano != null) {
            return resultado.pasarValidacionAdvertencia("Recuerde: el precio de la caja de banano no puede ser menor al precio m\u00ednimo de sustentaci\u00f3n");
        }
        return resultado;
    }

    @Override
    protected ResultadoValidacion validarValorRetenido(ResultadoValidacion resultado) {
        BigDecimal margenError;
        if (Util.getBigDecimal(this.getValorRetenido()).compareTo(Util.getBigDecimal(this.getBaseImponibleRenta())) == 1) {
            return resultado.fallarValidacion("El valor retenido no puede ser mayor al valor Base Imponible Renta");
        }
        boolean esRetencionConDividendoDesdeAgosto2015 = this.getPeriodo().isPeriodoDesdeAgosto2015() && Dividendos.RETENCIONES_CON_DIVIDENDOS_DESDE_MARZO_2015.containsKey(this.getConceptoRetencion());
        BigDecimal bigDecimal = margenError = esRetencionConDividendoDesdeAgosto2015 ? new BigDecimal("30.00") : Constantes.CERO_BIG;
        if (this.valorRetenidoCalculado.compareTo(Util.getBigDecimal(this.getValorRetenido())) != 0) {
            if (Util.isMargenErrorMasMenos(this.valorRetenidoCalculado, this.getValorRetenido(), margenError)) {
                return resultado.pasarValidacionAdvertencia("El Valor Retenido " + this.getValorRetenido() + " no corresponde al valor calculado " + this.valorRetenidoCalculado);
            }
            return this.controlarDividendos(resultado, esRetencionConDividendoDesdeAgosto2015);
        }
        this.validarPorcentajeRetencion(resultado);
        return resultado;
    }

    protected void validarPorcentajeRetencion(ResultadoValidacion resultado) {
        HashMap<String, String> rangosPermitidos = new HashMap<String, String>();
        rangosPermitidos.put("338", "1;2");
        String concepto = this.getConceptoRetencion();
        Double porcentaje = Double.valueOf(this.getPorcentajeRetencion());
        if (!this.getPeriodo().isPeriodoHastaDiciembre2019() && rangosPermitidos.containsKey(concepto)) {
            this.verificarPorcentajeEnRango(porcentaje, (String)rangosPermitidos.get(concepto), resultado);
        }
    }

    protected void verificarPorcentajeEnRango(Double porcentaje, String rango, ResultadoValidacion resultado) {
        String[] rangos = rango.split(";");
        Double valorMin = Double.valueOf(rangos[0]);
        Double valorMax = Double.valueOf(rangos[1]);
        if (porcentaje < valorMin || porcentaje > valorMax) {
            resultado.fallarValidacion("Para el C\u00d3DIGO de RETENCI\u00d3N " + this.getConceptoRetencion() + " reportado con el valor " + porcentaje + " no se encuentra dentro del rango permitido [" + valorMin + " a " + valorMax + "] para el periodo declarado " + this.getPeriodo().getMes() + " " + this.getPeriodo().getAnio());
        }
    }

    public ResultadoValidacion controlarDividendos(ResultadoValidacion resultado, boolean esRetencionConDividendoDesdeAgosto2015) {
        if (esRetencionConDividendoDesdeAgosto2015) {
            return resultado.pasarValidacionAdvertencia("El Valor Retenido " + this.getValorRetenido() + " no corresponde al valor calculado " + this.valorRetenidoCalculado);
        }
        return resultado.fallarValidacion("El Valor Retenido " + this.getValorRetenido() + " no corresponde al valor calculado " + this.valorRetenidoCalculado);
    }

    @Override
    protected void validacionAnotadaExitosa() {
        this.calcularValorRetenido();
        LocalDate fechaPeriodo = new LocalDate(this.getPeriodo().getAnio(), this.getPeriodo().getMes(), 1);
        this.retencionDividendos = UtilCatalogosATS.crearInstancia().obtenerRetencionDividendosPorBaseImponible(Util.getBigDecimal(this.getBaseImponibleRenta()), fechaPeriodo.toDate());
        if ((this.esPeriodoEnero2013Feb2015YesRetencionParaPersonasNaturales() || this.esPeriodoMarzoAJulio2015YesRetencionCalculadaConTabla()) && this.retencionDividendos != null) {
            this.calcularValorRetenidoPorDividendos();
        }
        if (this.getPeriodo().isPeriodoDeAnexoDesdeMarzo2015() && ConceptosRetencionBanano.RETENCIONES_EXPORTADORES_BANANEROS_DESDE_MARZO_2015.containsKey(this.getConceptoRetencion())) {
            this.calcularValorRetenidoPorBanano();
        }
    }

    private void calcularValorRetenidoPorBanano() {
        this.valorRetenidoCalculado = this.valorRetenidoPorBanano;
        if (ConceptosRetencionBanano.RETENCIONES_EXPORTADORES_BANANEROS_DESDE_MARZO_2015.containsKey(this.getConceptoRetencion())) {
            this.calcularValorRetenido();
        }
    }

    private ResultadoValidacion validarPorcentajeNoMayorA35DesdeAgosto2015(ResultadoValidacion resultadoValidacion) {
        BigDecimal porcentajeRetencion;
        if (Dividendos.RETENCIONES_CON_DIVIDENDOS_DESDE_MARZO_2015.containsKey(this.getConceptoRetencion()) && this.getPeriodo().isPeriodoDesdeAgosto2015() && Dividendos.PORCENTAJE_RETENCION_TOPE_DESDE_AGOSTO_2015.compareTo(porcentajeRetencion = new BigDecimal(this.getPorcentajeRetencion())) < 0) {
            return resultadoValidacion.fallarValidacion(String.format("El porcentaje de retencion no puede exceder el tope de %s por ciento", Dividendos.PORCENTAJE_RETENCION_TOPE_DESDE_AGOSTO_2015));
        }
        return resultadoValidacion;
    }

    private boolean esPeriodoEnero2013Feb2015YesRetencionParaPersonasNaturales() {
        return Dividendos.RETENCIONES_CON_DIVIDENDOS_NATURALES_2013_FEB_2015.containsKey(this.getConceptoRetencion()) && this.getPeriodo().isPeridoDeAnexoDesdeEnero2013aFebrero2015();
    }

    private boolean esPeriodoMarzoAJulio2015YesRetencionCalculadaConTabla() {
        return Dividendos.RETENCIONES_CON_DIVIDENDOS_DESDE_MARZO_2015.containsKey(this.getConceptoRetencion()) && this.getPeriodo().isPeriodoDesdeMarzo2015AJulio2015();
    }

    private boolean esPeriodoDesdeAgosto2015YesRetencionCalculadaConTabla() {
        return Dividendos.RETENCIONES_CON_DIVIDENDOS_DESDE_MARZO_2015.containsKey(this.getConceptoRetencion()) && this.getPeriodo().isPeriodoDesdeAgosto2015();
    }

    private boolean esPeriodoDesdeMarzoyEsExportacionDeBanano() {
        return this.getPeriodo().isPeriodoDeAnexoDesdeMarzo2015() && ConceptosRetencionBanano.RETENCIONES_EXPORTADORES_BANANEROS_DESDE_MARZO_2015.containsKey(this.getConceptoRetencion());
    }

    private Periodo getPeriodo() {
        return ((Iva)this.getRaizModelo()).periodo;
    }

    private void calcularValorRetenidoPorDividendos() {
        this.valorRetenidoCalculado = Util.getPorcentaje(Util.getBigDecimal(this.getBaseImponibleRenta()).subtract(this.retencionDividendos.get("fraccionBasica")), this.retencionDividendos.get("porcentajeRetencion")).add(this.retencionDividendos.get("retencionSobreFraccionBase"));
        this.setPorcentajeRetencion(this.retencionDividendos.get("porcentajeRetencion").toString());
        this.setValorRetenido(this.valorRetenidoCalculado.toString());
    }

    @Override
    public DetalleAirCompras crearCopiaEdicion() {
        DetalleAirCompras copia = new DetalleAirCompras();
        copia.setConceptoRetencion(super.getConceptoRetencion());
        copia.setDescripcionConcepto(super.getDescripcionConcepto());
        copia.setBaseImponibleRenta(super.getBaseImponibleRenta());
        copia.setValorRetenido(super.getValorRetenido());
        copia.setPorcentajeRetencion(super.getPorcentajeRetencion());
        copia.setFechaPagoDividendo(this.fechaPagoDividendo);
        copia.setImpuestoRentaSociedad(this.impuestoRentaSociedad);
        copia.setAnioUtilidadesDiv(this.anioUtilidadesDiv);
        copia.setNumeroCajasDeBanano(this.numeroCajasDeBanano);
        copia.setPrecioCajaDeBanano(this.precioCajaDeBanano);
        copia.setPorcentajeRetencionCalculoBanano(this.porcentajeRetencionCalculoBanano);
        copia.setValorRetenidoPorBanano(this.valorRetenidoPorBanano);
        copia.setPropietario(this.propietario);
        return copia;
    }

    @Override
    public void actualizarInformacion(DetalleAir copiaEdicion) {
        DetalleAirCompras detalleCompras = (DetalleAirCompras)copiaEdicion;
        this.setFechaPagoDividendo(detalleCompras.getFechaPagoDividendo());
        this.setImpuestoRentaSociedad(detalleCompras.getImpuestoRentaSociedad());
        this.setAnioUtilidadesDiv(detalleCompras.getAnioUtilidadesDiv());
        this.setNumeroCajasDeBanano(detalleCompras.getNumeroCajasDeBanano());
        this.setPrecioCajaDeBanano(detalleCompras.getPrecioCajaDeBanano());
        super.actualizarInformacion(copiaEdicion);
    }

    private ResultadoValidacion validarFechaPagoDividendo(ResultadoValidacion resultado) {
        Iva iva = (Iva)this.getRaizModelo();
        if (!Util.isFechaMenorIgualPeriodoMesAnio(this.getFechaPagoDividendo(), iva.getFechaPeriodoDeclarado())) {
            return resultado.fallarValidacion(String.format("La fecha de %s debe ser %s a la fecha del per\u00edodo informado", "pago del dividendo", "menor o igual"));
        }
        if (iva.getDatosDeclaracion().isEsMicroEmpresa()) {
            Date fechaRegistro = iva.getFechaRegistroContableSeleccionada();
            GregorianCalendar fechaRegistroC = new GregorianCalendar();
            fechaRegistroC.setTime(fechaRegistro);
            if (!Util.isFechaMenorIgualPeriodoMesAnio(this.getFechaPagoDividendo(), fechaRegistroC)) {
                SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
                return resultado.fallarValidacion(String.format("La fecha de %s debe ser %s a la fecha del registro contable %s para microempresas", "pago del dividendo", "menor o igual", formatter.format(fechaRegistro)));
            }
        }
        return resultado;
    }

    private ResultadoValidacion validarAnioUtilidadesDiv(ResultadoValidacion resultado) {
        if (Util.getInteger(this.getAnioUtilidadesDiv()) > ((Iva)this.getRaizModelo()).getFechaPeriodoDeclarado().get(1)) {
            return resultado.fallarValidacion("El valor A\u00f1o en que se generaron las utilidades atribuibles al dividendo, debe ser menor o igual al a\u00f1o del per\u00edodo declarado");
        }
        return resultado;
    }

    private ResultadoValidacion validarImpuestoRentaSociedad(ResultadoValidacion resultado) {
        if (Util.getBigDecimal(this.getImpuestoRentaSociedad()).compareTo(BigDecimal.ZERO) == 0) {
            resultado.pasarValidacionAdvertencia("El valor Impuesto a la Renta pagado por la sociedad correspondiente al dividendo debe ser diferente de cero");
        }
        if (Util.getBigDecimal(this.getImpuestoRentaSociedad()).compareTo(Util.getBigDecimal(this.getBaseImponibleRenta())) == 1) {
            resultado.pasarValidacionAdvertencia("El valor Impuesto a la Renta pagado por la sociedad correspondiente al dividendo es mayor al valor Base Imponible Renta");
        }
        return resultado;
    }

    @Override
    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("codRetAir");
        Element eValor = (Element)valorList.item(0);
        this.setConceptoRetencion(eValor.getTextContent().trim());
        this.setDescripcionConcepto(String.valueOf(this.getConceptoRetencion()) + "-" + UtilCatalogosATS.crearInstancia().obtenerDescripcionRetencion(this.getConceptoRetencion(), ((Iva)this.getRaizModelo()).getDatosDeclaracion().getMes(), ((Iva)this.getRaizModelo()).getDatosDeclaracion().getAnio(), ((Iva)this.getRaizModelo()).getDatosDeclaracion().getMicro()));
        valorList = elemento.getElementsByTagName("baseImpAir");
        eValor = (Element)valorList.item(0);
        this.setBaseImponibleRenta(eValor.getTextContent().trim());
        valorList = elemento.getElementsByTagName("valRetAir");
        eValor = (Element)valorList.item(0);
        this.setValorRetenido(eValor.getTextContent().trim());
        this.valorRetenidoCalculado = new BigDecimal(eValor.getTextContent().trim());
        valorList = elemento.getElementsByTagName("porcentajeAir");
        eValor = (Element)valorList.item(0);
        this.setPorcentajeRetencion(eValor.getTextContent().trim());
        if (Util.existeElementoImportar(elemento, "fechaPagoDiv")) {
            valorList = elemento.getElementsByTagName("fechaPagoDiv");
            eValor = (Element)valorList.item(0);
            this.fechaPagoDividendo = Util.importarFecha(eValor);
        }
        if (Util.existeElementoImportar(elemento, "imRentaSoc")) {
            valorList = elemento.getElementsByTagName("imRentaSoc");
            eValor = (Element)valorList.item(0);
            this.impuestoRentaSociedad = eValor.getTextContent().trim();
        }
        if (Util.existeElementoImportar(elemento, "anioUtDiv")) {
            valorList = elemento.getElementsByTagName("anioUtDiv");
            eValor = (Element)valorList.item(0);
            this.anioUtilidadesDiv = eValor.getTextContent().trim();
        }
        if (Util.existeElementoImportar(elemento, "numCajBan")) {
            valorList = elemento.getElementsByTagName("numCajBan");
            eValor = (Element)valorList.item(0);
            this.numeroCajasDeBanano = eValor.getTextContent().trim();
        }
        if (Util.existeElementoImportar(elemento, "precCajBan")) {
            valorList = elemento.getElementsByTagName("precCajBan");
            eValor = (Element)valorList.item(0);
            this.precioCajaDeBanano = eValor.getTextContent().trim();
        }
        return this;
    }

    public Date getFechaPagoDividendo() {
        return this.fechaPagoDividendo;
    }

    public String getImpuestoRentaSociedad() {
        return this.impuestoRentaSociedad;
    }

    public String getAnioUtilidadesDiv() {
        return this.anioUtilidadesDiv;
    }

    public BigDecimal getValorRetenidoPorBanano() {
        return this.valorRetenidoPorBanano;
    }

    public void setValorRetenidoPorBanano(BigDecimal valorRetenidoPorBanano) {
        this.valorRetenidoPorBanano = valorRetenidoPorBanano;
    }

    public void setFechaPagoDividendo(Date fechaPagoDividendo) {
        Date oldValue = this.fechaPagoDividendo;
        this.fechaPagoDividendo = fechaPagoDividendo;
        this.firePropertyChange(C_FECHA_PAGO_DIV, oldValue, this.fechaPagoDividendo);
    }

    public void setImpuestoRentaSociedad(String impuestoRentaSociedad) {
        String oldValue = this.impuestoRentaSociedad;
        this.impuestoRentaSociedad = impuestoRentaSociedad;
        this.firePropertyChange(C_IR_SOCIENDAD, oldValue, this.impuestoRentaSociedad);
    }

    public void setAnioUtilidadesDiv(String anioUtilidadesDiv) {
        String oldValue = this.anioUtilidadesDiv;
        this.anioUtilidadesDiv = anioUtilidadesDiv;
        this.firePropertyChange(C_ANIO_UTILIDADES_DIV, oldValue, this.anioUtilidadesDiv);
    }

    public String getNumeroCajasDeBanano() {
        return this.numeroCajasDeBanano;
    }

    public void setNumeroCajasDeBanano(String numeroCajasDeBanano) {
        String oldValue = this.numeroCajasDeBanano;
        this.numeroCajasDeBanano = numeroCajasDeBanano;
        this.firePropertyChange(NUMERO_CAJAS_DE_BANANO, oldValue, this.numeroCajasDeBanano);
    }

    public String getPrecioCajaDeBanano() {
        return this.precioCajaDeBanano;
    }

    public void setPrecioCajaDeBanano(String precioCajaDeBanano) {
        String oldValue = this.precioCajaDeBanano;
        this.precioCajaDeBanano = precioCajaDeBanano;
        this.firePropertyChange(PRECIO_CAJA_DE_BANANO, oldValue, this.precioCajaDeBanano);
    }

    public BigDecimal getPorcentajeRetencionCalculoBanano() {
        return this.porcentajeRetencionCalculoBanano;
    }

    public void setPorcentajeRetencionCalculoBanano(BigDecimal porcentajeRetencionCalculoBanano) {
        this.porcentajeRetencionCalculoBanano = porcentajeRetencionCalculoBanano;
    }

    @Override
    public Element exportar(Document documento, Element elemento) {
        Element em = documento.createElement("detalleAir");
        Element det = documento.createElement("codRetAir");
        det.setTextContent(this.getConceptoRetencion());
        em.appendChild(det);
        det = documento.createElement("baseImpAir");
        det.setTextContent(this.getBaseImponibleRenta());
        em.appendChild(det);
        det = documento.createElement("porcentajeAir");
        det.setTextContent(this.getPorcentajeRetencion());
        em.appendChild(det);
        det = documento.createElement("valRetAir");
        det.setTextContent(this.getValorRetenido());
        em.appendChild(det);
        if (this.esPeriodoEnero2013Feb2015YesRetencionParaPersonasNaturales() || this.esPeriodoMarzoAJulio2015YesRetencionCalculadaConTabla() || this.esPeriodoDesdeAgosto2015YesRetencionCalculadaConTabla()) {
            det = documento.createElement("fechaPagoDiv");
            det.setTextContent(Util.dateToStringWithFormat(this.getFechaPagoDividendo(), Constantes.FORMATO_FECHA.toPattern()));
            em.appendChild(det);
            det = documento.createElement("imRentaSoc");
            det.setTextContent(this.getImpuestoRentaSociedad());
            em.appendChild(det);
            det = documento.createElement("anioUtDiv");
            det.setTextContent(this.getAnioUtilidadesDiv());
            em.appendChild(det);
        }
        if (this.esPeriodoDesdeMarzoyEsExportacionDeBanano()) {
            det = documento.createElement("numCajBan");
            det.setTextContent(this.getNumeroCajasDeBanano());
            em.appendChild(det);
            det = documento.createElement("precCajBan");
            det.setTextContent(this.getPrecioCajaDeBanano());
            em.appendChild(det);
        }
        return em;
    }
}

